<?php
// --------------------
// CORS
// --------------------
header("Access-Control-Allow-Origin: https://saviourofsuccess.in");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

header('Content-Type: application/json');
require 'config.php';

// --------------------
// READ INPUT
// --------------------
$raw = file_get_contents("php://input");
$data = json_decode($raw, true);

if (!$data) {
    http_response_code(422);
    exit(json_encode(['ok'=>false,'message'=>'Invalid JSON']));
}

// --------------------
// TOKEN CHECK
// --------------------
if (!isset($data['token']) || $data['token'] !== WEBHOOK_TOKEN) {
    http_response_code(401);
    exit(json_encode(['ok'=>false,'message'=>'Unauthorized']));
}

// --------------------
// WEBSITE KEY CHECK
// --------------------
if (empty($data['website_key'])) {
    http_response_code(422);
    exit(json_encode(['ok'=>false,'message'=>'website_key missing']));
}

// --------------------
// FIND WEBSITE
// --------------------
$stmt = $pdo->prepare("SELECT id FROM websites WHERE `key` = ?");
$stmt->execute([$data['website_key']]);
$website = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$website) {
    http_response_code(404);
    exit(json_encode(['ok'=>false,'message'=>'Invalid website_key']));
}

$websiteId = $website['id'];

// --------------------
// SAFE FIELD EXTRACTION
// --------------------
$fields = $data['fields'] ?? [];
$meta   = $data['meta'] ?? [];

// --------------------
// INSERT LEAD
// --------------------
try {
    $stmt = $pdo->prepare("
        INSERT INTO leads
        (website_id, name, email, phone, payload, source_form, page_url, ip, created_at)
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, NOW())
    ");

    $stmt->execute([
        $websiteId,
        $fields['name']  ?? null,
        $fields['email'] ?? null,
        $fields['phone'] ?? null,
        json_encode($fields),
        $meta['form_name'] ?? null,
        $meta['page_url'] ?? null,
        $_SERVER['REMOTE_ADDR'] ?? null
    ]);

} catch (Exception $e) {
    http_response_code(500);
    exit(json_encode([
        'ok' => false,
        'message' => 'DB error',
        'error' => $e->getMessage() // TEMP: remove later
    ]));
}

// --------------------
// SUCCESS
// --------------------
echo json_encode([
    'ok' => true,
    'lead_id' => $pdo->lastInsertId()
]);
