<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Website;
use App\Models\Lead;
use Illuminate\Support\Facades\Validator;

class LeadIngestController extends Controller
{
    public function ingest(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'website_key' => 'required|string',
            'token'       => 'required|string',
            'fields'      => 'required|array',
            'meta'        => 'nullable|array',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'ok' => false,
                'errors' => $validator->errors()
            ], 422);
        }

        $website = Website::where('key', $request->website_key)->first();

        if (!$website || !$website->api_token || !hash_equals($website->api_token, $request->token)) {
            return response()->json(['ok' => false, 'message' => 'Unauthorized'], 401);
        }

        $fields = $request->fields;
        $meta   = $request->meta ?? [];

        // common mapping (works even if not present)
        $name  = $fields['name']  ?? $fields['full_name'] ?? null;
        $email = $fields['email'] ?? null;
        $phone = $fields['phone'] ?? $fields['mobile'] ?? null;

        $lead = Lead::create([
            'website_id'  => $website->id,
            'name'        => is_string($name) ? $name : null,
            'email'       => is_string($email) ? $email : null,
            'phone'       => is_string($phone) ? $phone : null,
            'payload'     => $fields, // store all dynamic fields
            'source_form' => $meta['form_name'] ?? $meta['form_id'] ?? null,
            'page_url'    => $meta['page_url'] ?? null,
            'ip'          => $request->ip(),
        ]);

        return response()->json([
            'ok' => true,
            'lead_id' => $lead->id
        ]);
    }
}
