@extends('layouts.admin', ['title' => ($pageTitle ?? 'All Leads') . ' - HIPL CRM'])

@section('content')
<div class="d-flex align-items-center justify-content-between mb-4">
    <div>
        <h2 class="mb-0 fw-bold">{{ $pageTitle ?? 'All Leads' }}</h2>
        <div class="text-muted">Filter and manage leads</div>
    </div>

    <a class="btn btn-success" href="{{ route('leads.export', request()->query()) }}">Export CSV</a>
</div>

<div class="card shadow-sm mb-3">
    <div class="card-body">
        <form class="row g-3" method="GET" action="{{ route('leads.index') }}">
            <div class="col-12 col-md-3">
                <label class="form-label">Website</label>
                <select name="website" class="form-select">
                    <option value="">All</option>
                    @foreach($websites as $site)
                        <option value="{{ $site->key }}" @selected(($filters['website'] ?? '') == $site->key)>
                            {{ $site->name }}
                        </option>
                    @endforeach
                </select>
            </div>

            <div class="col-12 col-md-3">
                <label class="form-label">Month (YYYY-MM)</label>
                <input name="month" value="{{ $filters['month'] ?? '' }}" class="form-control" placeholder="2026-01">
            </div>

            <div class="col-12 col-md-3">
                <label class="form-label">Start Date</label>
                <input type="date" name="start_date" value="{{ $filters['start_date'] ?? '' }}" class="form-control">
            </div>

            <div class="col-12 col-md-3">
                <label class="form-label">End Date</label>
                <input type="date" name="end_date" value="{{ $filters['end_date'] ?? '' }}" class="form-control">
            </div>

            <div class="col-12 d-flex gap-2">
                <button class="btn btn-dark">Apply</button>
                <a class="btn btn-light" href="{{ route('leads.index') }}">Reset</a>
            </div>
        </form>
    </div>
</div>

<div class="card shadow-sm">
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover align-middle mb-0">
                <thead class="table-light">
                <tr>
                    <th class="ps-3">#</th>
                    <th>Website</th>
                    <th>Name</th>
                    <th>Email</th>
                    <th>Phone</th>
                    <th>Form</th>
                    <th>Created</th>
                </tr>
                </thead>
                <tbody>
                @forelse($leads as $lead)
                    <tr>
                        <td class="ps-3 fw-semibold">{{ $lead->id }}</td>
                        <td>{{ $lead->website->name ?? '-' }}</td>
                        <td>{{ $lead->name ?? '-' }}</td>
                        <td>{{ $lead->email ?? '-' }}</td>
                        <td>{{ $lead->phone ?? '-' }}</td>
                        <td>{{ $lead->source_form ?? '-' }}</td>
                        <td>{{ $lead->created_at?->format('Y-m-d H:i') }}</td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="7" class="text-center text-muted py-5">No leads found.</td>
                    </tr>
                @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <div class="card-footer bg-white">
        {{ $leads->links() }}
    </div>
</div>
@endsection
