<?php

use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\LeadController;

Route::get('/', function () {
    return view('welcome');
});

Route::get('/dashboard', function () {
    return view('dashboard');
})->middleware(['auth', 'verified'])->name('dashboard');

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});



// use App\Http\Controllers\LeadController;

Route::middleware(['auth'])->group(function () {
    Route::get('/dashboard', [LeadController::class, 'dashboard'])->name('dashboard');

    Route::get('/leads', [LeadController::class, 'index'])->name('leads.index');
    Route::get('/leads/export', [LeadController::class, 'exportCsv'])->name('leads.export');

    // Website-wise leads page
    Route::get('/leads/website/{websiteKey}', [LeadController::class, 'website'])
        ->name('leads.website');
});



require __DIR__.'/auth.php';
