

<?php $__env->startSection('content'); ?>
<div class="d-flex align-items-center justify-content-between mb-4">
    <div>
        <h2 class="mb-0 fw-bold"><?php echo e($pageTitle ?? 'All Leads'); ?></h2>
        <div class="text-muted">Filter and manage leads</div>
    </div>

    <a class="btn btn-success" href="<?php echo e(route('leads.export', request()->query())); ?>">Export CSV</a>
</div>

<div class="card shadow-sm mb-3">
    <div class="card-body">
        <form class="row g-3" method="GET" action="<?php echo e(route('leads.index')); ?>">
            <div class="col-12 col-md-3">
                <label class="form-label">Website</label>
                <select name="website" class="form-select">
                    <option value="">All</option>
                    <?php $__currentLoopData = $websites; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $site): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($site->key); ?>" <?php if(($filters['website'] ?? '') == $site->key): echo 'selected'; endif; ?>>
                            <?php echo e($site->name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            <div class="col-12 col-md-3">
                <label class="form-label">Month (YYYY-MM)</label>
                <input name="month" value="<?php echo e($filters['month'] ?? ''); ?>" class="form-control" placeholder="2026-01">
            </div>

            <div class="col-12 col-md-3">
                <label class="form-label">Start Date</label>
                <input type="date" name="start_date" value="<?php echo e($filters['start_date'] ?? ''); ?>" class="form-control">
            </div>

            <div class="col-12 col-md-3">
                <label class="form-label">End Date</label>
                <input type="date" name="end_date" value="<?php echo e($filters['end_date'] ?? ''); ?>" class="form-control">
            </div>

            <div class="col-12 d-flex gap-2">
                <button class="btn btn-dark">Apply</button>
                <a class="btn btn-light" href="<?php echo e(route('leads.index')); ?>">Reset</a>
            </div>
        </form>
    </div>
</div>

<div class="card shadow-sm">
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover align-middle mb-0">
                <thead class="table-light">
                <tr>
                    <th class="ps-3">#</th>
                    <th>Website</th>
                    <th>Name</th>
                    <th>Email</th>
                    <th>Phone</th>
                    <th>Form</th>
                    <th>Created</th>
                </tr>
                </thead>
                <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $leads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lead): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td class="ps-3 fw-semibold"><?php echo e($lead->id); ?></td>
                        <td><?php echo e($lead->website->name ?? '-'); ?></td>
                        <td><?php echo e($lead->name ?? '-'); ?></td>
                        <td><?php echo e($lead->email ?? '-'); ?></td>
                        <td><?php echo e($lead->phone ?? '-'); ?></td>
                        <td><?php echo e($lead->source_form ?? '-'); ?></td>
                        <td><?php echo e($lead->created_at?->format('Y-m-d H:i')); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="7" class="text-center text-muted py-5">No leads found.</td>
                    </tr>
                <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <div class="card-footer bg-white">
        <?php echo e($leads->links()); ?>

    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', ['title' => ($pageTitle ?? 'All Leads') . ' - HIPL CRM'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\Laravel_CRM\hipl-crm-new\resources\views/leads/index.blade.php ENDPATH**/ ?>